<!DOCTYPE html>
<html>
<head>
    <title>XML Yükleme İşlemi</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            text-align: center;
            padding: 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            margin: 0;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            max-width: 500px;
            width: 90%;
        }
        h3 {
            color: #333;
            margin-bottom: 30px;
            font-size: 24px;
            font-weight: 600;
        }
        .progress-container {
            margin: 30px 0;
        }
        .progress-bar {
            width: 100%;
            height: 25px;
            background: #e9ecef;
            border-radius: 12px;
            overflow: hidden;
            position: relative;
            box-shadow: inset 0 2px 4px rgba(0,0,0,0.1);
        }
        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #28a745, #20c997);
            width: 0%;
            transition: width 0.5s ease;
            position: relative;
            overflow: hidden;
        }
        .progress-fill::after {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            background-image: linear-gradient(
                -45deg,
                rgba(255, 255, 255, .2) 25%,
                transparent 25%,
                transparent 50%,
                rgba(255, 255, 255, .2) 50%,
                rgba(255, 255, 255, .2) 75%,
                transparent 75%,
                transparent
            );
            background-size: 50px 50px;
            animation: move 2s linear infinite;
        }
        @keyframes move {
            0% { background-position: 0 0; }
            100% { background-position: 50px 50px; }
        }
        .progress-text {
            font-size: 16px;
            margin: 15px 0;
            color: #555;
            font-weight: 500;
        }
        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
            margin: 15px 0;
        }
        .status-processing {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        .status-completed {
            background: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .status-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .time-info {
            font-size: 14px;
            color: #666;
            margin-top: 20px;
        }
        .btn {
            padding: 10px 20px;
            border: none;
            border-radius: 6px;
            font-size: 14px;
            font-weight: 500;
            cursor: pointer;
            margin: 5px;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background: #007bff;
            color: white;
        }
        .btn-primary:hover {
            background: #0056b3;
        }
        .btn-secondary {
            background: #6c757d;
            color: white;
        }
        .btn-secondary:hover {
            background: #545b62;
        }
        .estimated-time {
            font-size: 16px;
            color: #007bff;
            font-weight: 600;
            margin: 10px 0;
        }
        .spinner {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #007bff;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="spinner" id="spinner"></div>
        <h3>XML Yükleme İşlemi</h3>
        
        <div class="status-badge status-processing" id="statusBadge">
            İşlem başlatılıyor...
        </div>
        
        <div class="progress-container">
            <div class="progress-bar">
                <div class="progress-fill" id="progressBar"></div>
            </div>
            <div class="progress-text" id="progressText">Hazırlanıyor...</div>
        </div>
        
        <div class="estimated-time" id="estimatedTime">
            Tahmini süre: 10-15 dakika
        </div>
        
        <div class="time-info" id="timeInfo">
            Başlangıç: <span id="startTime"><?php echo date('H:i:s'); ?></span>
        </div>
        
        <div style="margin-top: 30px;">
            <button class="btn btn-primary" onclick="location.reload()" id="refreshBtn">Yenile</button>
            <button class="btn btn-secondary" onclick="window.close()" id="closeBtn">Kapat</button>
        </div>
    </div>

    <script>
        let startTime = Date.now();
        let lastProgressValue = 0;
        
        function updateProgress() {
            fetch('xml_progress.php')
                .then(response => response.text())
                .then(data => {
                    const parts = data.split('|');
                    const progressValue = parts[0];
                    const progressMessage = parts[1] || 'İşleniyor...';
                    
                    const progressBar = document.getElementById('progressBar');
                    const progressText = document.getElementById('progressText');
                    const statusBadge = document.getElementById('statusBadge');
                    const estimatedTime = document.getElementById('estimatedTime');
                    const spinner = document.getElementById('spinner');
                    
                    progressText.textContent = progressMessage;
                    
                    if (progressValue === 'done') {
                        // İşlem tamamlandı
                        progressBar.style.width = '100%';
                        statusBadge.textContent = 'İşlem Tamamlandı!';
                        statusBadge.className = 'status-badge status-completed';
                        estimatedTime.textContent = 'İşlem başarıyla tamamlandı!';
                        spinner.style.display = 'none';
                        
                        setTimeout(() => {
                            window.close();
                        }, 3000);
                        
                    } else if (progressValue === 'error') {
                        // Hata durumu
                        statusBadge.textContent = 'Hata Oluştu!';
                        statusBadge.className = 'status-badge status-error';
                        estimatedTime.textContent = 'Lütfen sistem yöneticisi ile iletişime geçin.';
                        spinner.style.display = 'none';
                        
                    } else if (progressValue > 0) {
                        // İşlem devam ediyor
                        const currentProgress = parseInt(progressValue);
                        const percent = Math.min((currentProgress / 10000) * 100, 100);
                        progressBar.style.width = percent + '%';
                        
                        statusBadge.textContent = 'İşlem Devam Ediyor...';
                        statusBadge.className = 'status-badge status-processing';
                        
                        // Tahmini süre hesaplama
                        if (currentProgress > lastProgressValue && currentProgress > 100) {
                            const elapsed = (Date.now() - startTime) / 1000; // saniye
                            const rate = currentProgress / elapsed; // ürün/saniye
                            const remaining = (10000 - currentProgress) / rate; // kalan saniye
                            const remainingMinutes = Math.ceil(remaining / 60);
                            
                            if (remainingMinutes > 0 && remainingMinutes < 100) {
                                estimatedTime.textContent = `Tahmini kalan süre: ${remainingMinutes} dakika`;
                            } else {
                                estimatedTime.textContent = 'Tahmini süre hesaplanıyor...';
                            }
                        }
                        
                        lastProgressValue = currentProgress;
                    } else {
                        // Başlangıç durumu
                        statusBadge.textContent = 'İşlem Başlatılıyor...';
                        statusBadge.className = 'status-badge status-processing';
                        estimatedTime.textContent = 'Tahmini süre: 10-15 dakika';
                    }
                })
                .catch(error => {
                    console.error('Progress güncellenirken hata:', error);
                    document.getElementById('statusBadge').textContent = 'Bağlantı Hatası';
                    document.getElementById('statusBadge').className = 'status-badge status-error';
                });
        }
        
        // Sayfa yüklendiğinde başlat ve her 2 saniyede güncelle
        updateProgress();
        setInterval(updateProgress, 2000);
    </script>
</body>
</html>
