-- Departman Yönetimi için Gerekli Tablolar
-- Bu SQL dosyasını veritabanınızda çalıştırarak gerekli tabloları oluşturabilirsiniz

-- 1. Departman tablosu
CREATE TABLE IF NOT EXISTS `departman` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adi` varchar(255) NOT NULL,
  `aciklama` text,
  `durum` tinyint(1) NOT NULL DEFAULT '1',
  `tarih` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 2. Yetki tablosu (eğer yoksa)
CREATE TABLE IF NOT EXISTS `yetki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `departmanid` int(11) NOT NULL,
  `departmanadi` varchar(255) NOT NULL,
  `menu` text NOT NULL,
  `durum` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `departmanid` (`departmanid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 3. Menu tablosu (eğer yoksa)
CREATE TABLE IF NOT EXISTS `menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menuadi` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL,
  `ustmenu` int(11) NOT NULL DEFAULT '0',
  `sira` int(11) NOT NULL DEFAULT '0',
  `durum` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Örnek departman verileri
INSERT INTO `departman` (`adi`, `aciklama`, `durum`, `tarih`) VALUES
('Satış Sorumlusu', 'Satış işlemleri ve müşteri ilişkileri', 1, NOW()),
('Muhasebe', 'Mali işler ve muhasebe işlemleri', 1, NOW()),
('İnsan Kaynakları', 'Personel yönetimi ve işe alım', 1, NOW()),
('Teknik Destek', 'Sistem yönetimi ve teknik destek', 1, NOW()),
('Genel Müdür', 'Tüm departmanlara erişim', 1, NOW());

-- Mevcut menü yapısına uygun departman yönetimi menüsü ekle
-- Ana menü olarak "Admin Yönetimi" ekleyelim (ID 8'den sonra)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('extreme,enterprise', 'Admin Yönetimi', '#', 'mdi mdi-account-supervisor', 0, 8, 1);

-- Mevcut menü yapısına uygun alt menüler ekle
-- Admin Yönetimi alt menüleri (ID 9 olacak - yeni eklenen ana menü)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('extreme,enterprise', 'Admin Ekle', 'admin-ekle', 'mdi mdi-account-plus', 9, 1, 1),
('extreme,enterprise', 'Tüm Adminler', 'tum-adminler', 'mdi mdi-account-multiple', 9, 2, 1),
('extreme,enterprise', 'Departman Yönetimi', 'departman', 'mdi mdi-office-building', 9, 3, 1);

-- Ürün İşlemleri alt menüleri (ID 4)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('basic,plus,extreme,enterprise', 'Ürün Ekle', 'urun-ekle', 'mdi mdi-plus-circle', 4, 1, 1),
('basic,plus,extreme,enterprise', 'Tüm Ürünler', 'tum-urunler', 'mdi mdi-package-variant', 4, 2, 1),
('basic,plus,extreme,enterprise', 'Kategori Ekle', 'kategori-ekle', 'mdi mdi-folder-plus', 4, 3, 1),
('basic,plus,extreme,enterprise', 'Tüm Kategoriler', 'tum-kategoriler', 'mdi mdi-folder-multiple', 4, 4, 1),
('basic,plus,extreme,enterprise', 'Marka Ekle', 'marka-ekle', 'mdi mdi-tag-plus', 4, 5, 1),
('basic,plus,extreme,enterprise', 'Tüm Markalar', 'tum-markalar', 'mdi mdi-tag-multiple', 4, 6, 1);

-- Toplu İşlemler alt menüleri (ID 5)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('plus,extreme,enterprise', 'XML Yükleme Merkezi', 'xml-yukle', 'mdi mdi-upload', 5, 1, 1),
('plus,extreme,enterprise', 'XML Çıktısı', 'xml', 'mdi mdi-download', 5, 2, 1),
('plus,extreme,enterprise', 'Toplu Güncelleme', 'toplu-guncelleme', 'mdi mdi-update', 5, 3, 1);

-- İletişim Merkezi alt menüleri (ID 6)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('basic,plus,extreme,enterprise', 'Destek Merkezi', 'destek-merkezi', 'mdi mdi-help-circle', 6, 1, 1),
('basic,plus,extreme,enterprise', 'Ürün Yorumları', 'urun-yorumlari', 'mdi mdi-comment-text', 6, 2, 1),
('basic,plus,extreme,enterprise', 'Blog Yorumları', 'blog-yorumlari', 'mdi mdi-comment-multiple', 6, 3, 1),
('basic,plus,extreme,enterprise', 'Gelen Kutusu', 'gelen-kutusu', 'mdi mdi-inbox', 6, 4, 1),
('basic,plus,extreme,enterprise', 'E-Bülten', 'e-bulten', 'mdi mdi-email-newsletter', 6, 5, 1),
('basic,plus,extreme,enterprise', 'Toplu Eposta', 'toplu-eposta', 'mdi mdi-email-multiple', 6, 6, 1);

-- Statik Sayfalar alt menüleri (ID 7)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('basic,plus,extreme,enterprise', 'Bilgi Sayfaları', 'tum-sayfalar', 'mdi mdi-file-document', 7, 1, 1),
('basic,plus,extreme,enterprise', 'Slider', 'tum-sliderler', 'mdi mdi-view-carousel', 7, 2, 1),
('basic,plus,extreme,enterprise', 'Kampanyalar', 'tum-kampanyalar', 'mdi mdi-tag-heart', 7, 3, 1),
('basic,plus,extreme,enterprise', 'Blog', 'tum-bloglar', 'mdi mdi-blogger', 7, 4, 1),
('basic,plus,extreme,enterprise', 'Sıkça Sorulan Sorular', 'tum-sssler', 'mdi mdi-help-box', 7, 5, 1);

-- Üye Yönetimi alt menüleri (ID 8)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('basic,plus,extreme,enterprise', 'Üye Ekle', 'uye-ekle', 'mdi mdi-account-plus', 8, 1, 1),
('basic,plus,extreme,enterprise', 'Tüm Üyeler', 'tum-uyeler', 'mdi mdi-account-multiple', 8, 2, 1);

-- Sistem Modülleri alt menüleri (ID 3)
INSERT INTO `menu` (`paketadi`, `menuadi`, `link`, `icon`, `ustmenu`, `sira`, `durum`) VALUES
('basic,plus,extreme,enterprise', 'Site Ayarları', 'siteayarlari', 'mdi mdi-cog', 3, 1, 1),
('basic,plus,extreme,enterprise', 'Tema Ayarları', 'temaayarlari', 'mdi mdi-palette', 3, 2, 1),
('basic,plus,extreme,enterprise', 'Sistem Ayarları', 'sistemayarlari', 'mdi mdi-settings', 3, 3, 1),
('basic,plus,extreme,enterprise', 'Sanal Poslar', 'sanal-poslar', 'mdi mdi-credit-card', 3, 4, 1),
('basic,plus,extreme,enterprise', 'Eposta Servisi', 'eposta-servisi', 'mdi mdi-email', 3, 5, 1),
('basic,plus,extreme,enterprise', 'SMS Servisleri', 'sms-servisleri', 'mdi mdi-message-text', 3, 6, 1),
('basic,plus,extreme,enterprise', 'Kargo Servisleri', 'tum-kargolar', 'mdi mdi-truck', 3, 7, 1),
('basic,plus,extreme,enterprise', 'Kuponlar', 'tum-kuponlar', 'mdi mdi-ticket-percent', 3, 8, 1),
('basic,plus,extreme,enterprise', 'Hediye Çekleri', 'tum-hediyecekleri', 'mdi mdi-gift', 3, 9, 1),
('basic,plus,extreme,enterprise', 'Etiket Modülü', 'etiketler', 'mdi mdi-tag', 3, 10, 1);

-- Örnek yetki verileri (mevcut menü yapısına göre)
-- Satış Sorumlusu: Siparişlerim (2), Ürün İşlemleri (4), Üye Yönetimi (8)
INSERT INTO `yetki` (`departmanid`, `departmanadi`, `menu`, `durum`) VALUES
(1, 'Satış Sorumlusu', '2,4,8', 1);

-- Muhasebe: Siparişlerim (2) - sadece sipariş takibi için
INSERT INTO `yetki` (`departmanid`, `departmanadi`, `menu`, `durum`) VALUES
(2, 'Muhasebe', '2', 1);

-- İnsan Kaynakları: Admin Yönetimi (9)
INSERT INTO `yetki` (`departmanid`, `departmanadi`, `menu`, `durum`) VALUES
(3, 'İnsan Kaynakları', '9', 1);

-- Teknik Destek: Sistem Modülleri (3)
INSERT INTO `yetki` (`departmanid`, `departmanadi`, `menu`, `durum`) VALUES
(4, 'Teknik Destek', '3', 1);

-- Genel Müdür: Tüm menüler
INSERT INTO `yetki` (`departmanid`, `departmanadi`, `menu`, `durum`) VALUES
(5, 'Genel Müdür', '2,3,4,5,6,7,8,9', 1);
